<?php

namespace Modules\UddoktaPay\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Addons\Entities\Addon;
use Modules\UddoktaPay\Entities\UddoktaPay;
use Modules\UddoktaPay\Entities\UddoktaPayBody;
use Modules\UddoktaPay\Http\Requests\UddoktaPayRequest;

class UddoktaPayController extends Controller
{

    /**
     * Store a newly created resource in storage.
     *
     *
     * @return mixed
     */
    public function store(UddoktaPayRequest $request)
    {
        $uddoktaPayBody = new UddoktaPayBody($request);

        UddoktaPay::updateOrCreate(
            ['alias' => 'uddoktapay'],
            [
                'name' => 'UddoktaPay',
                'instruction' => $request->instruction,
                'status' => $request->status,
                'baseUrl' => $request->baseUrl,
                'image' => 'thumbnail.png',
                'data' => json_encode($uddoktaPayBody),
            ]
        );

        return back()->with(['AddonStatus' => 'success', 'AddonMessage' => __('UddoktaPay settings updated.')]);
    }

    /**
     * Returns form for the edit modal
     *
     * @param \Illuminate\Http\Request
     * @return JsonResponse
     */
    public function edit(Request $request)
    {
        try {
            $module = UddoktaPay::first()->data;
        } catch (\Exception $e) {
            $module = null;
        }
        $addon = Addon::findOrFail('UddoktaPay');

        return response()->json(
            [
                'html' => view('gateway::partial.form', compact('module', 'addon'))->render(),
                'status' => true,
            ],
            200
        );
    }

}
