<?php
    $iconBoxes = $component->iconbox ?? [];
    $totalBoxes = is_array($iconBoxes) ? count($iconBoxes) : 0;
?>
<div class="hidden lg:grid <?php echo e($component->sidebox_show == 1 ? 'grid-cols-3' : ''); ?> gap-5 mx-4 lg:mx-4 xl:mx-32 2xl:mx-64 3xl:mx-92 md:my-12 my-10 h-33"
    style="margin-top:<?php echo e($component->mt); ?>;margin-bottom:<?php echo e($component->mb); ?>;">
    <div class="col-span-2 border border-dashed border-gray-400"
        style="border-radius: <?php echo e($component->rounded == 1 ? '6px' : '0'); ?>;">
        <div class="grid grid-cols-<?php echo e($totalBoxes); ?>">
            <?php $__currentLoopData = $iconBoxes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $box): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $box = miniCollection($box);
                ?>
                <div>
                    <div class="my-6 px-6 border-r lead">
                        <div class="flex">
                            <?php if($box->image): ?>
                                <div>
                                    <img src="<?php echo e(pathToUrl($box->image)); ?>"
                                        class="iconbox-image-icons neg-transition-scale" alt="<?php echo e($box->title); ?>">
                                </div>
                            <?php endif; ?>
                            <p class="text-base font-bold pl-3 text-gray-12 dm-bold"><?php echo $box->title; ?>

                            </p>
                        </div>
                        <p class="roboto-regular text-13 mt-3.5 text-gray-10"><?php echo $box->subtitle; ?></p>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
    <?php if($component->sidebox_show == 1): ?>
        <?php
            $sidebox = is_array($component->sidebox) ? miniCollection($component->sidebox) : miniCollection([]);
        ?>
        <div class="col-span-1 flex justify-between items-center bg-gray-12 <?php echo e($component->rounded == 1 ? 'rounded-md' : ''); ?> p-15p">
            <div class="w-2/3 ml-5p">
                <p class="text-2xl primary-text-color font-bold dm-bold"><?php echo $sidebox->title; ?></p>
                <p class="text-white text-sm mt-1 leading-normal roboto-medium ltr:pr-8 rtl:pl-8"><?php echo $sidebox->description; ?></p>
            </div>
            <?php if($sidebox->sidetext || $sidebox->image): ?>
                <div class="w-1/3 px-1 h-full border primary-text-color flex justify-center items-center text-base font-medium border-dashed border-white rounded">
                    <?php if($sidebox->image): ?>
                        <img src="<?php echo e(pathToUrl($sidebox->image)); ?>" alt="<?php echo e($sidebox->title); ?>">
                    <?php else: ?>
                        <p class="text-center dm-bold capitalize"><?php echo $sidebox->sidetext; ?></p>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        <?php
            unset($sidebox);
        ?>
    <?php endif; ?>
</div>
<?php
    unset($box);
    unset($component);
    unset($iconBoxes);
?>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/CMS/Resources/views/templates/blocks/iconbox-grid-template-v1.blade.php ENDPATH**/ ?>