
<?php $__env->startSection('page_title', __('SSO Service')); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12" id="sso-settings-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10  ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    <?php echo $__env->make('admin.layouts.includes.account_settings_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <?php if(session('errorMgs')): ?>
                            <div class="alert alert-warning fade in alert-dismissable">
                                <strong><?php echo e(__('Warning')); ?>!</strong> <?php echo e(session('errorMgs')); ?>. <a class="close"
                                    href="#" data-dismiss="alert" aria-label="close" title="close">×</a>
                            </div>
                        <?php endif; ?>
                        <span id="smtp_head">
                            <div class="card-header p-t-20 border-bottom">
                                <h5><?php echo e(__('SSO Service')); ?></h5>
                            </div>
                        </span>
                        <div class="card-body">
                            <form action="<?php echo e(route('sso.index')); ?>" method="post" id="myform1" class="form-horizontal">
                                <?php echo csrf_field(); ?>
                                <?php
                                    $requiredData = !empty($preference) ? json_decode($preference) : [];
                                    $msg = __('This field is required.');
                                ?>
                                <div>
                                    <div class="d-flex justify-content-between">
                                        <div id="#headingOne">
                                            <h5 class="text-btn"><?php echo e(__('Google')); ?></h5>
                                        </div>
                                        <div class="ltr:me-3 rtl:ms-3">
                                            <div class="switch switch-bg d-inline">
                                                <input type="checkbox" name="sso_service[]" id="sso_google" value="Google"
                                                    <?php echo e(!empty(preference('sso_service')) && in_array('Google', json_decode(preference('sso_service'))) ? 'checked' : ''); ?>>
                                                <label for="sso_google" class="cr top-2p"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="mt-2">
                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label align-left"><?php echo e(__('Client ID')); ?></label>

                                        <div class="col-sm-8">
                                                <input type="text" value="<?php echo e(env('GOOGLE_CLIENT_ID')); ?>" class="form-control removeSpace inputFieldDesign" name="data[google][client_id]">
                                        </div>
                                    </div>

                                    <div class="clearfix"></div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label align-left"><?php echo e(__('Client Secret')); ?></label>

                                        <div class="col-sm-8">
                                                <input type="text" value="<?php echo e(env('GOOGLE_CLIENT_SECRET')); ?>" class="form-control removeSpace" inputFieldDesign name="data[google][client_secret]">
                                        </div>
                                    </div>

                                    <div class="d-flex justify-content-between mt-37p">
                                        <div id="#headingOne">
                                            <h5 class="text-btn"><?php echo e(__('Facebook')); ?></h5>
                                        </div>
                                        <div class="ltr:me-3 rtl:ms-3">
                                            <div class="switch switch-bg d-inline">
                                                <input type="checkbox" name="sso_service[]" id="sso_facebook"
                                                    value="Facebook"
                                                    <?php echo e(!empty(preference('sso_service')) && in_array('Facebook', json_decode(preference('sso_service'))) ? 'checked' : ''); ?>>
                                                <label for="sso_facebook" class="cr top-2p"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <hr class="mt-2">
                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label align-left "><?php echo e(__('Client ID')); ?></label>

                                        <div class="col-sm-8">
                                            <input type="text" value="<?php echo e(env('FACEBOOK_CLIENT_ID')); ?>" class="form-control removeSpace inputFieldDesign" name="data[facebook][client_id]">
                                        </div>
                                    </div>

                                    <div class="clearfix"></div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 control-label align-left"><?php echo e(__('Client Secret')); ?></label>

                                        <div class="col-sm-8">
                                            <input type="text" value="<?php echo e(env('FACEBOOK_CLIENT_SECRET')); ?>" class="form-control removeSpace inputFieldDesign" name="data[facebook][client_secret]">
                                        </div>
                                    </div>
                                </div>

                                <div class="card-footer p-0">
                                    <div class="form-group row">
                                        <label for="btn_save" class="col-sm-3 control-label"></label>
                                        <div class="col-sm-12">
                                            <button type="submit" class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left"
                                                id="footer-btn">
                                                <?php echo e(__('Save')); ?>

                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/settings.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/sso_service/index.blade.php ENDPATH**/ ?>