
<?php $__env->startSection('page_title', __('Media Manager')); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/fileupload/css/fileupload.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('Modules/MediaManager/Resources/assets/css/media-manager.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <div class="col-sm-12" id="media-manager-container">
        <div class="card">
            <div class="card-header d-md-flex justify-content-between align-items-center">
                <h5 class="mb-0 h6"><a href="<?php echo e(route('mediaManager.uploadedFiles')); ?>"><?php echo e(__('All files')); ?></h5>
                <?php if(in_array('Modules\MediaManager\Http\Controllers\MediaManagerController@create', $prms)): ?>
                    <a href="<?php echo e(route('mediaManager.create')); ?>"
                        class="btn m-0 btn-outline-primary custom-btn-small add-files-btn">
                        <span class="fa fa-plus"> &nbsp;</span><?php echo e(__('Add Files')); ?>

                    </a>
                <?php endif; ?>
            </div>
            <form action='<?php echo e(route('mediaManager.uploadedFiles')); ?>' method="get" class="form-horizontal px-4"
                id="media-list" enctype="multipart/form-data">
                <div class="form-search-container" class="mx-2">
                    <div class="dropdown col-md-3 p-0 mb-3">
                        <select class="form-control select2 form-control-xs sort-option" name="sort_value">
                            <option <?php echo e(request()->sort_value == 'newest' ? ' selected' : ''); ?> value="newest">
                                <?php echo e(__('Sort by newest')); ?></option>
                            <option <?php echo e(request()->sort_value == 'oldest' ? ' selected' : ''); ?> value="oldest">
                                <?php echo e(__('Sort by oldest')); ?></option>
                            <option <?php echo e(request()->sort_value == 'smallest' ? ' selected' : ''); ?> value="smallest">
                                <?php echo e(__('Sort by smallest')); ?></option>
                            <option <?php echo e(request()->sort_value == 'largest' ? ' selected' : ''); ?> value="largest">
                                <?php echo e(__('Sort by largest')); ?></option>
                        </select>
                    </div>
                    <div class="justify-content-between align-items-center d-flex position-relative mb-3">
                        <input type="text" class="form-control form-control-xs search-button image-search-button"
                            name="sort_name" placeholder="<?php echo e(__('Search your files')); ?>"
                            value="<?php echo e(!empty(request('sort_name')) ? request('sort_name') : ''); ?>">
                        <button type="submit" class="search-button media-manager-search"><i
                                class="fa fa-search"></i></button>
                    </div>
                </div>
            </form>
            <div class="card-block">
                <div class="card-arrangement-design">
                    <?php if(count($files) >= 1): ?>
                        <?php $__currentLoopData = $files; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $file): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $imagePath = $file->fileUrlNew(['id' => $file->id, 'type' => 'items', 'isMediamanager' => true]) ?>
                        <?php if(!empty($imagePath)): ?>
                            <div class="card-design">
                                <div class="thumbnail card-border-design position-relative">
                                    <div class="card-dropdown">
                                        <span class="dropdown-icon" data-bs-toggle="dropdown"><i
                                                class="fa fa-ellipsis-v"></i></span>
                                        <div class="dropdown-menu dropdown-menu-right media-dropdown" aria-labelledby="dropdownMenuButton">
                                            <a class="dropdown-item image-drop-down-menu dropdown-menus-design text-left"
                                                data-bs-toggle="modal" data-bs-target="#exampleModal" href="#"
                                                id="<?php echo e($file->id); ?>"
                                                type="<?php echo e(isset($file->params['type']) ? $file->params['type'] : ''); ?>"
                                                size="<?php echo e(!empty($file->file_size) ? $file->file_size . __('KB') : ''); ?>"
                                                name="<?php echo e($file->original_file_name); ?>"
                                                user="<?php echo e(isset($file->user) && !empty($file->user->name) ? $file->user->name : ''); ?>"
                                                time="<?php echo e($file->created_at); ?>">
                                                <i class="fa fa-info-circle ltr:me-2 rtl:ms-2"></i>
                                                <?php echo e(__('Details Info')); ?></a>
                                            <a class="dropdown-item image-drop-down-menu dropdown-menus-design text-left"
                                                href="<?php echo e(route('mediaManager.download', ['id' => $file->id])); ?>">
                                                <i class="fa fa-download ltr:me-2 rtl:ms-2"></i>
                                                <?php echo e(__('Download')); ?></a>
                                            <a class="dropdown-item copy-link image-drop-down-menu dropdown-menus-design text-left"
                                                data-url="<?php echo e($file->fileUrlNew(['id' => $file->id, 'type' => 'products'])); ?>"
                                                href="javascript:void(0)">
                                                <i class="fa fa-copy ltr:me-2 rtl:ms-2"></i>
                                                <?php echo e(__('Copy Link')); ?></a>
                                            <a class="dropdown-item delete-image image-drop-down-menu dropdown-menus-design text-left"
                                                data-id="<?php echo e($file->id); ?>" href="javascript:void(0)">
                                                <i class="fa fa-trash ltr:me-2 rtl:ms-2"></i>
                                                <?php echo e(__('Delete')); ?></a>
                                        </div>
                                    </div>
                                    <!-- Modal -->
                                    <div class="modal fade" id="exampleModal" tabindex="-1" role="dialog"
                                        aria-labelledby="exampleModalTitle" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="exampleModalLongTitle">
                                                        <?php echo e(__('File Info')); ?></h5>
                                                    <a type="button" class="close h5" data-bs-dismiss="modal"
                                                        aria-label="Close">
                                                        <span aria-hidden="true">&times;</span>
                                                    </a>
                                                </div>
                                                <div id="info-modal-content">
                                                    <div class="modal-body c-scrollbar-light position-relative">
                                                        <div class="form-group">
                                                            <label class="pb-2"><?php echo e(__('File Name')); ?></label>
                                                            <input type="text" class="form-control inputFieldDesign" readonly id="file-name">
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="pb-2"><?php echo e(__('File Type')); ?></label>
                                                            <input type="text" class="form-control inputFieldDesign" readonly id="file-type">
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="pb-2"><?php echo e(__('File Size')); ?></label>
                                                            <input type="text" class="form-control inputFieldDesign" readonly id="file-size">
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="pb-2"><?php echo e(__('Uploaded By')); ?></label>
                                                            <input type="text" class="form-control inputFieldDesign" readonly id="uploaded-by">
                                                        </div>
                                                        <div class="form-group">
                                                            <label class="pb-2"><?php echo e(__('Uploaded At')); ?></label>
                                                            <input type="text" class="form-control inputFieldDesign" readonly id="uploaded-date">
                                                            <input type="hidden" class="form-control inputFieldDesign" readonly id="file-id">
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <div class="text-center">
                                                            <a class="btn btn-secondary info-download-button"
                                                                id="download-image" href="javascript:void(0)"
                                                                target="_blank"><?php echo e(__('Download')); ?></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="px-3">
                                        <div class="thumb-<?php echo e($file->id); ?>" id="modal-img-des-container">
                                            <div>
                                                <?php if(isset($file->params) &&
                                                !empty($file->params['type'] && in_array($file->params['type'], getFileExtensions(6)))): ?>
                                                <video class="media-manager-image img-fluid img-thumbnail p-0 mb-1 image-id neg-transition-scale" controls>
                                                    <source src="<?php echo e($imagePath); ?>" type="video/mp4">
                                                </video>
                                                <?php elseif(isset($file->params) &&
                                                    !empty($file->params['type'] && in_array($file->params['type'], getFileExtensions(5)))): ?>
                                                    <div
                                                        class="card-file-thumb img-fluid img-thumbnail image-id p-4 media-manager-image">
                                                        <i class="fa fa-file fa-6" aria-hidden="true"></i>
                                                    </div>
                                                <?php else: ?>

                                                    <img src="<?php echo e($imagePath); ?>"
                                                        id="<?php echo e($file->id); ?>" alt="<?php echo e(__('Image')); ?>"
                                                        class="media-manager-image img-fluid img-thumbnail p-0 mb-1 image-id neg-transition-scale" />
                                                <?php endif; ?>
                                            </div>
                                            <div class="pb-1">
                                                <p class="m-0 font-weight-bold">
                                                    <?php echo e(nameConversion($file->original_file_name)); ?></p>
                                                <small
                                                    class="image-size-name"><?php echo e(!empty($file->file_size) ? number_format($file->file_size, preference('decimal_digits'), '.', ',') : ''); ?>

                                                    <?php echo e(__('KB')); ?></small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <p class="no-file-message"><?php echo e(__('Media not found')); ?></p>
                    <?php endif; ?>
                </div>
                <div class="media-manager-pagiantion image-modal-pagination"> <?php echo e($files->links()); ?> </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/datta-able/plugins/sweetalert/js/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/fileupload/js/dropzone.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/MediaManager/Resources/assets/js/media-manager.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/MediaManager/Resources/views/uploaded_files.blade.php ENDPATH**/ ?>