<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(languageDirection()); ?>">

<head>
    <title><?php echo e(trimWords(preference('company_name'), 17)); ?> | <?php echo $__env->yieldContent('page_title', env('APP_NAME', '')); ?></title>
    <meta charset="UTF-8">
    <meta rel="stylesheet" name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="<?php echo e(asset('public/css/tailwind-custom.min.css')); ?>" />
    <link href="<?php echo e(asset('public/frontend/assets/css/google-font-inter.min.css')); ?>" >
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/main.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/css/app.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/dark.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/fontawesome/css/fontawesome-all.min.css')); ?>">
    <script src="<?php echo e(asset('public/frontend/assets/js/alpine.min.js')); ?>" defer></script>
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/user-panel.min.css')); ?>">
    <?php if(file_exists(base_path('public/js/lang/' . config('app.locale') . '.js'))): ?>
        <script src="<?php echo e(asset('public/js/lang/' . config('app.locale') . '.js')); ?>"></script>
    <?php else: ?>
        <script type="text/javascript">const translates = {}</script>
    <?php endif; ?>
    <?php
        $favicon = App\Models\Preference::getFavicon();
    ?>
    <?php if(!empty($favicon)): ?>
        <link rel='shortcut icon' href="<?php echo e($favicon); ?>" type='image/x-icon' />
    <?php endif; ?>
    <?php
        $page = \Modules\CMS\Entities\Page::firstWhere('default', '1');
        $layout = $page->layout;
        $primaryColor = option($layout . '_template_primary_color', '#FCCA19');
    ?>
    <style>
        :root{
            --primary-color: <?php echo e($primaryColor); ?>;
        }
    </style>
    <?php echo $__env->yieldContent('parent-css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/site_custom.min.css')); ?>">
    <script type="text/javascript">
        'use strict';
        var SITE_URL              = "<?php echo e(URL::to('/')); ?>";
        var token                 = '<?php echo csrf_token(); ?>';
        var language_direction = '<?php echo \Cache::get(config('cache.prefix') . '-language-direction'); ?>';
    </script>

    <!-- Required Js -->
    <script src="<?php echo e(asset('public/dist/js/jquery.min.js')); ?>"></script>

</head>

<!-- partial:index.partial.html -->

<body class="antialiased bg-gray-100 overflow-hidden m-0" x-data="{'darkMode': false}" x-init="
darkMode = JSON.parse(localStorage.getItem('darkMode'));
$watch('darkMode', value => localStorage.setItem('darkMode', JSON.stringify(value)))">
<?php
    $themeOption = \Modules\CMS\Http\Models\ThemeOption::getAll();
    $headerMobileLogo = $themeOption
        ->where('name', 'default_template_header_mobile_logo')
        ->first();
?>
<div :class="{'dark': darkMode === true}">
    <div class=" dark:bg-red-2 dark:text-gray-100 ">


        <div x-data="{ sidemenu: false }" class="h-screen flex overflow-hidden" x-cloak
             @keydown.window.escape="sidemenu = false">
                <!-- sidebar start -->
                <?php echo $__env->make('site.layouts.user_panel.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- sidebar end -->
                <div class="flex-1 flex-col relative z-0 overflow-y-auto pb-8 dark:bg-red-1 bg-white">
                <!-- header start -->
               <?php echo $__env->make('../site/layouts.user_panel.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- header end -->
                <?php echo $__env->make('../site/layouts.user_panel.includes.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <!-- content start-->
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- Main content -->
                         <?php echo $__env->yieldContent('parent-content'); ?>
                    </div>
                </div>
                <!-- content end -->
            </div>
        </div>
    </div>
    <!-- partial -->
    <script src="<?php echo e(asset('public/frontend/assets/js/user-dashboard.min.js')); ?>"></script>
<?php echo $__env->yieldContent('parent-js'); ?>

</body>

</html>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/site/layouts/user_panel/master.blade.php ENDPATH**/ ?>