<?php

namespace Modules\Newsletter\Http\Requests;

use App\Rules\CheckValidEmail;
use Illuminate\Foundation\Http\FormRequest;

class StoreSubscriberRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {

        return [
            'email' => ['required', 'unique:subscribers,email', new CheckValidEmail()],
        ];

    }
}
