<?php

return [
    'name' => 'UddoktaPay',

    'alias' => 'uddoktapay',

    'logo' => 'Modules/UddoktaPay/Resources/assets/logo.png',

    // Uddoktapay addon settings

    'options' => [
        ['label' => __('Settings'), 'type' => 'modal', 'url' => 'uddoktapay.edit'],
        ['label' => __('UddoktaPay Documentation'), 'target' => '_blank', 'url' => 'https://docs.uddoktapay.com/help-center'],
    ],

    /**
     * Uddokatapay data validation
     */
    'validation' => [
        'rules' => [
            'apiKey' => 'required',
            'baseUrl' => 'required',
        ],
        'attributes' => [
            'apiKey' => __('API Key'),
            'baseUrl' => __('Base Url'),
        ],
    ],
    'fields' => [
        'apiKey' => [
            'label' => __('API Key'),
            'type' => 'text',
            'required' => true,
        ],
        'instruction' => [
            'label' => __('Instruction'),
            'type' => 'textarea',
        ],
        'baseUrl' => [
            'label' => __('Base Url'),
            'type' => 'text',
            'required' => true,
        ],
        'status' => [
            'label' => __('Status'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Active' => 1,
                'Inactive' =>  0,
            ],
        ],
    ],

    'store_route' => 'uddoktapay.store',

];

