<?php

/**
 * @author TechVillage <support@techvill.org>
 *
 * @contributor Ashraful Rasel <[ashraful.techvill@gmail.com]>
 *
 * @created 11-11-2024
 */

namespace Modules\UddoktaPay\Response;

use Modules\Gateway\Contracts\HasDataResponseInterface;
use Modules\Gateway\Response\Response;

class UddoktaPayResponse extends Response implements HasDataResponseInterface
{
    protected $response;

    private $data;

    public function __construct($data, $uddoktaPayResponse)
    {
        $this->data = $data;
        $this->response = $uddoktaPayResponse;
        $this->updateStatus();

        return $this;
    }

    public function getRawResponse(): string
    {
        return json_encode($this->response);
    }

    protected function updateStatus()
    {
        if ($this->response->status == 'COMPLETED') {
            $this->setPaymentStatus('completed');
        } else {
            $this->setPaymentStatus('failed');
        }
    }

    public function getResponse(): string
    {
        return json_encode($this->getSimpleResponse());
    }

    private function getSimpleResponse()
    {
        return [
            'amount' => $this->response->amount,
            'amount_captured' => $this->response->charged_amount,
            'currency' => $this->data->currency_code,
            'code' => $this->data->code,
            'payment_method' => $this->response->payment_method,
            'sender_number' => $this->response->sender_number,
            'transaction_id' => $this->response->transaction_id,
            'invoice_id' => $this->response->invoice_id,
        ];
    }

    public function getGateway(): string
    {
        return 'UddoktaPay';
    }

    protected function setPaymentStatus($status)
    {
        $this->status = $status;
    }
}
