<!DOCTYPE html>
<html>

<head>
    <title><?php echo e(trimWords(preference('company_name'), 17)); ?> | <?php echo $__env->yieldContent('page_title', env('APP_NAME', '')); ?></title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <?php echo $__env->make('admin.layouts.includes.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Favicon icon -->
    <?php
        $favicon = App\Models\Preference::getFavicon()
    ?>
    <?php if(!empty($favicon)): ?>
        <link rel='shortcut icon' href="<?php echo e($favicon); ?>" type='image/x-icon' />
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/fontawesome/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/animation/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/css/bootstrap.min.css')); ?>">
    <?php if(file_exists(base_path('public/js/lang/' . config('app.locale') . '.js'))): ?>
        <script src="<?php echo e(asset('public/js/lang/' . config('app.locale') . '.js')); ?>"></script>
    <?php else: ?>
        <script type="text/javascript">const translates = {}</script>
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/feather/css/feather.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/jquery-scrollbar/css/jquery.scrollbar.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/datta/datta-icon.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/jquery-scrollbar/css/perfect-scrollbar.min.css')); ?>">
    <script type="text/javascript">
        'use strict';
        var SITE_URL              = "<?php echo e(URL::to('/')); ?>";
        var currencySymbol        = '<?php echo currency()->symbol; ?>';
        var decimal_digits        = '<?php echo preference('decimal_digits'); ?>';
        var thousand_separator    = '<?php echo preference('thousand_separator'); ?>';
        var symbol_position       = '<?php echo preference('symbol_position'); ?>';
        var dateFormat            = '<?php echo preference('date_format_type'); ?>';
        var token                 = '<?php echo csrf_token(); ?>';
        var app_locale_url        = "<?php echo url('/resources/lang/' . config('app.locale') . '.json'); ?>";
        var row_per_page          = '<?php echo preference('row_per_page'); ?>';
        var language_direction    = '<?php echo \Cache::get(config('cache.prefix') . '-language-direction'); ?>';
    </script>
</head>
<body>
    <div class="auth-wrapper">
        <div id="admin-login-container" class="admin-login-container">
            <div class="card">
                <span class="multi-logo">
                    <?php
                        $logo = App\Models\Preference::getLogo('company_logo');
                    ?>
                    <img class="admin-login-logo img-fluid" src="<?php echo e($logo); ?>" alt="<?php echo e(trimWords(preference('company_name'), 17)); ?>">
                </span>
                <div class="card-body text-center admin-login">
                    <h3 id="login-text" class="login-text"><?php echo $__env->yieldContent('login_title'); ?></h3>
                    <hr>
                    <h3 class="mb-4"><b><?php echo e(!empty($companyData) ? $companyData : ''); ?></b></h3>
                    <div class="alert-reset-container">
                        <?php if(count($errors) > 0): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="reset-error-msg"><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>

                        <?php $__currentLoopData = ['success', 'danger', 'fail', 'warning', 'info']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($message = Session::get($msg)): ?>
                                <div class="alert-reset alert alert-<?php echo e($msg == 'fail' ? 'danger' : $msg); ?>">
                                    <button type="button" class="close" data-dismiss="alert">×</button>
                                    <strong class="reset-success-msg"><?php echo e($message); ?></strong>
                                </div>
                                <?php break; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <?php echo $__env->yieldContent('content'); ?>
                </div>
            </div>
        </div>
    </div>
 <script>
        var loginNeeded=false;
 </script>
    <?php echo $__env->yieldContent('js'); ?>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/slim.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/js/vendor-all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/js/pcoded.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/login.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/be-seller.min.js')); ?>"></script>

</body>
</html>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/layouts/app2.blade.php ENDPATH**/ ?>