<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(languageDirection()); ?>">

<head>
    <?php echo do_action('after_vendor_panel_head', ''); ?>

    <title><?php echo e(trimWords(preference('company_name'), 17)); ?> | <?php echo $__env->yieldContent('page_title', env('APP_NAME', '')); ?></title>
    <!-- HTML5 Shim and Respond.js IE10 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 10]>
        <script src="<?php echo e(asset('public/dist/js/respond.min.js')); ?>"></script>
    <![endif]-->
    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <?php echo $__env->make('vendor.layouts.includes.meta', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Favicon icon -->
    <?php
        $favicon = App\Models\Preference::getFavicon();
    ?>
    <?php if(!empty($favicon)): ?>
        <link rel='shortcut icon' href="<?php echo e($favicon); ?>" type='image/x-icon' />
    <?php endif; ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/fontawesome/css/fontawesome-all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/material/css/materialdesignicons.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/flag/css/flag-icon.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/animation/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/css/style.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/fonts/feather/css/feather.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/jquery-scrollbar/css/jquery.scrollbar.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able//fonts/datta/datta-icon.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/jquery-scrollbar/css/perfect-scrollbar.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/custom.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/vendor-responsiveness.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/plugins/select2/css/select2.min.css')); ?>">

    <!--Custom CSS that was written on view-->

    <?php echo do_action("before_vendor_panel_css_{$view_name}", ''); ?>

    <?php echo $__env->yieldContent('parent-css'); ?>

    <?php echo do_action("after_vendor_panel_css_{$view_name}", ''); ?>

    <!-- Theme style RTL -->
    <?php if(\Cache::get(config('cache.prefix') . '-language-direction') == 'rtl'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('public/datta-able/css/layouts/rtl.min.css')); ?>">
    <?php endif; ?>


    <?php if(file_exists(base_path('public/js/lang/' . config('app.locale') . '.js'))): ?>
        <script src="<?php echo e(asset('public/js/lang/' . config('app.locale') . '.js')); ?>"></script>
    <?php else: ?>
        <script type="text/javascript">
            const translates = {};
        </script>
    <?php endif; ?>
    <script type="text/javascript">
        'use strict';
        var SITE_URL = "<?php echo e(URL::to('/vendor')); ?>";
        var ADMIN_SITE_URL = "<?php echo e(URL::to('/admin')); ?>";
        var currencySymbol = '<?php echo currency()->symbol; ?>';
        var decimal_digits = '<?php echo preference('decimal_digits'); ?>';
        var thousand_separator = '<?php echo preference('thousand_separator'); ?>';
        var symbol_position = '<?php echo preference('symbol_position'); ?>';
        var dateFormat = '<?php echo preference('date_format_type'); ?>';
        var token = '<?php echo csrf_token(); ?>';
        var app_locale_url = "<?php echo url('/resources/lang/' . config('app.locale') . '.json'); ?>";
        var row_per_page = '<?php echo preference('row_per_page'); ?>';
        var language_direction = '<?php echo \Cache::get(config('cache.prefix') . '-language-direction'); ?>';
        var summernote_regex = /<\/*(?:applet|b(?:ase|gsound|link)|embed|frame(?:set)?|ilayer|l(?:ayer|ink)|meta|object|s(?:cript|tyle)|t(?:itle|extarea)|xml)[^>]*?>/gi;
    </script>

    <!-- Required Js -->
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/slim.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/plugins/bootstrap-v5/js/bootstrap.min.js')); ?>"></script>
    <?php echo do_action('before_vendor_panel_head', ''); ?>
</head>

<?php
    $appName = env('APP_NAME', '');
    $appName = !empty($appName) && mb_strlen($appName) > 19 ? mb_substr($appName, 0, 17) . '..' : $appName;
?>

<body <?php echo apply_filters('vendor_panel_body_tag', ''); ?>>
    <?php echo do_action('after_vendor_panel_body', ''); ?>
    <!-- [ Pre-loader ] start -->
    <div class="loader-bg">
        <div class="loader-track">
            <div class="loader-fill"></div>
        </div>
    </div>
    <!-- [ Pre-loader ] End -->

    <!-- [ navigation menu ] start -->
    <?php echo do_action('before_vendor_panel_sidebar', ''); ?>
    <?php echo $__env->make('vendor.layouts.includes.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- [ navigation menu ] end -->

    <!-- [ Header ] start -->
    <?php echo do_action('before_vendor_panel_header', ''); ?>
    <?php echo $__env->make('vendor.layouts.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo do_action('after_vendor_panel_header', ''); ?>
    <!-- [ Header ] end -->

    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-wrapper">
            <div class="pcoded-content">
                <div class="pcoded-inner-content">
                    <!-- [ breadcrumb ] start -->
                    <?php echo $__env->make('vendor.layouts.includes.notifications', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <!-- [ breadcrumb ] end -->
                    <div class="main-body">
                        <div class="page-wrapper">
                            <!-- [ Main Content ] start -->
                            <?php echo do_action('before_vendor_panel_content', ''); ?>
                            <?php echo do_action("before_vendor_panel_content_{$view_name}", ''); ?>
                            <div class="row">
                                <div class="col-sm-12 list-container">
                                    <?php echo $__env->yieldContent('parent-content'); ?>
                                </div>
                            </div>
                            <?php echo do_action('after_vendor_panel_content', ''); ?>
                            <?php echo do_action("after_vendor_panel_content_{$view_name}", ''); ?>
                            <!-- [ Main Content ] end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- [ Main Content ] end -->

    <!-- Warning Section start -->
    <!-- Older IE warning message -->
    <!--[if lt IE 11]>
        <div class="ie-warning">
            <h1><?php echo e(__('Warning')); ?>!!</h1>
            <p><?php echo e(__('You are using an outdated version of Internet Explorer, please upgrade to any of the following web browsers to access this website.')); ?>

            </p>
            <div class="iew-container">
                <ul class="iew-download">
                    <li>
                        <a href="//www.google.com/chrome/">
                            <img src="<?php echo e(asset('public/datta-able/images/browser/chrome.png')); ?>" alt="Chrome">
                            <div>Chrome</div>
                        </a>
                    </li>
                    <li>
                        <a href="//www.mozilla.org/en-US/firefox/new/">
                            <img src="<?php echo e(asset('public/datta-able/images/browser/firefox.png')); ?>" alt="Firefox">
                            <div>Firefox</div>
                        </a>
                    </li>
                    <li>
                        <a href="//www.opera.com">
                            <img src="<?php echo e(asset('public/datta-able/images/browser/opera.png')); ?>" alt="Opera">
                            <div>Opera</div>
                        </a>
                    </li>
                    <li>
                        <a href="//www.apple.com/safari/">
                            <img src="<?php echo e(asset('public/datta-able/images/browser/safari.png')); ?>" alt="Safari">
                            <div>Safari</div>
                        </a>
                    </li>
                    <li>
                        <a href="//windows.microsoft.com/en-us/internet-explorer/download-ie">
                            <img src="<?php echo e(asset('public/datta-able/images/browser/ie.png')); ?>" alt="<?php echo e(__('Image')); ?>">
                            <div>IE (11 & above)</div>
                        </a>
                    </li>
                </ul>
            </div>
            <p><?php echo e(__('Sorry for the inconvenience!')); ?></p>
        </div>
    <![endif]-->
    <!-- Warning Section Ends -->
    
    <!-- Required Js -->
    <script src="<?php echo e(asset('public/dist/plugins/jQueryUI/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/datta-able/js/pcoded.min.js')); ?>"></script>
    <!-- Custom Js -->
    <script src="<?php echo e(asset('public/datta-able/plugins/select2/js/select2.full.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/app-layout.min.js?v=2.0')); ?>"></script>
    <?php echo do_action("before_vendor_panel_js_{$view_name}", ''); ?>
    <?php echo $__env->yieldContent('parent-js'); ?>
    <?php echo do_action("after_vendor_panel_js_{$view_name}", ''); ?>
    
    <?php echo do_action('before_vendor_panel_body', ''); ?>
</body>

</html>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/vendor/layouts/master.blade.php ENDPATH**/ ?>