<!DOCTYPE html>
<html lang="<?php echo e(App::getLocale()); ?>" dir="<?php echo e(languageDirection()); ?>">

<head>
    <?php echo do_action('after_site_head', ''); ?>
    <?php if ($__env->exists('googleanalytics::partials.google_analytics_header')) echo $__env->make('googleanalytics::partials.google_analytics_header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <title><?php echo e(trimWords(preference('company_name'), 17)); ?> | <?php echo $__env->yieldContent('page_title', env('APP_NAME', '')); ?></title>
    <meta charset="UTF-8" />

    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <?php echo $__env->yieldContent('seo'); ?>
    <?php
        $themeOption = \Modules\CMS\Http\Models\ThemeOption::getAll();

        $layout = 'default';
        if (!isset($page->layout)) {
            $page = \Modules\CMS\Entities\Page::firstWhere('default', '1');
        }
        $layout = $page->layout;
        $primaryColor = option($layout . '_template_primary_color', '#FCCA19');

        [$fontFamily, $genericFamily] = explode(',', option($layout . '_template_font_family', 'DM Sans, sans-serif'));

    ?>
    <style>
        :root {
            --primary-color: <?php echo e($primaryColor); ?>;
            --global-font: <?php echo e($fontFamily . ',' . $genericFamily); ?>;
            --semi-primary-color: <?php echo e($primaryColor . '11'); ?>;
        }
    </style>
    <!-- Meta Pixel Code -->
<script>
!function(f,b,e,v,n,t,s)
{if(f.fbq)return;n=f.fbq=function(){n.callMethod?
n.callMethod.apply(n,arguments):n.queue.push(arguments)};
if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
n.queue=[];t=b.createElement(e);t.async=!0;
t.src=v;s=b.getElementsByTagName(e)[0];
s.parentNode.insertBefore(t,s)}(window, document,'script',
'https://connect.facebook.net/en_US/fbevents.js');
fbq('init', '2355381278153504');
fbq('track', 'PageView');
</script>
<noscript><img height="1" width="1" style="display:none"
src="https://www.facebook.com/tr?id=2355381278153504&ev=PageView&noscript=1"
/></noscript>
<!-- End Meta Pixel Code -->
    <link rel="stylesheet" href="<?php echo e(asset('public/css/app.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/css/tailwind-custom.min.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/swiper/swiper-bundle.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/animate.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/google-font-roboto.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/font-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/plugins/jQueryUI/jquery-ui.min.css')); ?>" type="text/css" />

    <?php
        $favicon = App\Models\Preference::getFavicon();
    ?>
    <?php if(!empty($favicon)): ?>
        <link rel='shortcut icon' href="<?php echo e($favicon); ?>" type='image/x-icon' />
    <?php endif; ?>
    <!--Custom CSS that was written on view-->
    <?php echo do_action("before_site_css_{$view_name}", ''); ?>

    <?php echo $__env->yieldContent('parent-css'); ?>

    <?php echo do_action("after_site_css_{$view_name}", ''); ?>
    <!-- Menubar css -->
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/assets/css/ionicon.min.css')); ?>" />
    <!-- Menubar css end-->

    <!-- Custom CSS-->
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/site_custom.min.css')); ?>">

    <!-- User define custom dynamic css file -->
    <?php if(File::exists('Modules/CMS/Resources/assets/css/user-custom.css')): ?>
        <link rel="stylesheet" href="<?php echo e(asset('Modules/CMS/Resources/assets/css/user-custom.css?v=' . time())); ?>">
    <?php endif; ?>
    
    <?php if(file_exists(base_path('public/js/lang/' . config('app.locale') . '.js'))): ?>
        <script src="<?php echo e(asset('public/js/lang/' . config('app.locale') . '.js')); ?>"></script>
    <?php else: ?>
        <script type="text/javascript">
            const translates = {};
        </script>
    <?php endif; ?>
    <script type="text/javascript">
        'use strict';
        var SITE_URL = "<?php echo e(URL::to('/')); ?>";
        var currencySymbol = '<?php echo currency()->symbol; ?>';
        var decimal_digits = '<?php echo preference('decimal_digits'); ?>';
        var thousand_separator = '<?php echo preference('thousand_separator'); ?>';
        var symbol_position = '<?php echo preference('symbol_position'); ?>';
        var dateFormat = '<?php echo preference('date_format_type'); ?>';
        var token = '<?php echo csrf_token(); ?>';
        var app_locale_url = "<?php echo url('/resources/lang/' . config('app.locale') . '.json'); ?>";
        var row_per_page = '<?php echo preference('row_per_page'); ?>';
        var language_direction = '<?php echo \Cache::get(config('cache.prefix') . '-language-direction'); ?>';
        var totalProductPerPage = '<?php echo totalProductPerPage(); ?>';
        var variationId = null;
        var itemType = '<?php echo e(\App\Enums\ProductType::$Simple); ?>';
        var tempItemType = '<?php echo e(\App\Enums\ProductType::$Simple); ?>';
        var isManageStock = null;
        var stockQty = null;
        var variationAttributeIds = [];
        var backOrders = 0;
        var qtyArray = [];
        var isGroupProduct = false;
        var offerTimer = null;
        var offerTimerDetailsPage = null;
        var tempIsGroupProduct = false;
        <?php if(auth()->guard()->check()): ?>
        var userLoggedIn = true;
        <?php else: ?>
            var userLoggedIn = false;
        <?php endif; ?>
    </script>
    <!-- Required Js -->
    <script src="<?php echo e(asset('public/dist/js/jquery.min.js')); ?>"></script>
    <!-- Affiliate Code Common Header -->
    
    <?php echo do_action('before_site_head', ''); ?>
</head>

<body <?php echo apply_filters('site_body_tag', 'class="antialiased min-h-screen"'); ?> x-data="{ 'layout': 'grid' }">
    <?php echo do_action('after_site_body', ''); ?>
    <?php

        $headerLogo = $themeOption->where('name', $layout . '_template_header_logo')->first();
        $headerMobileLogo = $themeOption->where('name', $layout . '_template_header_mobile_logo')->first();

        $header = option($layout . '_template_header', '');
        $footer = option($layout . '_template_footer', '');
        $isEnableProduct = option($layout . '_template_product', '');

        $footerLogo = $themeOption->where('name', $layout . '_template_footer_logo')->first();
        $googlePlay = $themeOption->where('name', $layout . '_template_google_play')->first();
        $appStore = $themeOption->where('name', $layout . '_template_app_store')->first();
        $downloadGooglePlay = $themeOption->where('name', $layout . '_template_download_google_play_logo')->first();
        $downloadAppStore = $themeOption->where('name', $layout . '_template_download_app_store_logo')->first();
        $paymentMethods = $themeOption->where('name', $layout . '_template_payment_methods')->first();
    ?>
    <!-- Top nav start -->
    <?php echo do_action('before_site_top_nav', ''); ?>

    <?php echo $__env->make('../site/layouts.includes.top_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- Top nav end -->

    <!-- header section start -->
    <?php echo do_action('before_site_header', ''); ?>

    <?php echo $__env->make('../site/layouts.includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- header section end -->

    <!-- Bottom nav section start-->
    <?php echo do_action('before_site_bottom_nav', ''); ?>

    <?php echo $__env->make('../site/layouts.includes.bottom_nav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo do_action('after_site_bottom_nav', ''); ?>
    <!-- Bottom nav section End-->

    <div class="main-body">
        <div class="page-wrapper">
            <!-- Main content -->
            <?php echo do_action('before_site_content', ''); ?>
            <?php echo do_action("before_site_content_{$view_name}", ''); ?>

            <?php echo $__env->yieldContent('parent-content'); ?>

            <?php echo do_action('after_site_content', ''); ?>
            <?php echo do_action("after_site_content_{$view_name}", ''); ?>
            <!-- Main content end -->
        </div>
    </div>

    
    <?php echo $__env->make('../site/layouts.includes.login_modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- section footer start -->
    <?php echo do_action('before_site_footer', ''); ?>

    <?php echo $__env->make('../site/layouts.includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo do_action('after_site_footer', ''); ?>
    <!-- section footer end -->
    

    <?php echo $__env->make('../site/layouts.includes.product_view', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <script src="<?php echo e(asset('public/dist/js/custom/site/formatting.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/swiper/swiper-bundle.min.js')); ?>"></script>

    <!-- Custom Js -->
    <script src="<?php echo e(asset('public/dist/plugins/jQueryUI/jquery-ui.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/js/alpine.min.js')); ?>" defer></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/drawer.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/js/script.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/cart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/lang.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/site-nav.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/js/sweet-alert2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/dist/js/custom/site/site.min.js')); ?>"></script>
    <script src="<?php echo e(asset('public/frontend/assets/js/main.min.js')); ?>"></script>

    <?php echo do_action("before_site_js_{$view_name}", ''); ?>

    <?php echo $__env->yieldContent('parent-js'); ?>

    <?php echo do_action("after_site_js_{$view_name}", ''); ?>

    <!-- User define custom dynamic js file -->
    <?php if(File::exists('Modules/CMS/Resources/assets/js/user-custom.js')): ?>
        <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/user-custom.js?v=' . time())); ?>"></script>
    <?php endif; ?>

    <?php echo do_action('before_site_body', ''); ?>
</body>

</html>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/site/layouts/master.blade.php ENDPATH**/ ?>