
<?php $__env->startSection('page_title', 'Sliders'); ?>
<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <div class="col-sm-12 list-container" id="slider-list-container">
        <div class="card">
            <div class="card-header">
                <h5><a href="<?php echo e(route('slider.index')); ?>"><?php echo e(__('Sliders')); ?></a></h5>
                <div class="card-header-right d-inline-block">
                    <?php if(in_array('Modules\CMS\Http\Controllers\SliderController@store', $prms)): ?>
                        <a href="javascript:void(0)" data-bs-toggle="modal" data-bs-target="#add-category-name"
                            class="add-payment-term btn btn-outline-primary custom-btn-small">
                            <span class="fa fa-plus"> &nbsp;</span>
                            <?php echo e(__('Add :x', ['x' => 'Slider'])); ?>

                        </a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body px-0">
                <div class="card-block pt-2 px-2">
                    <div class="col-sm-12 row m-0 p-0">
                        <?php $__empty_1 = true; $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <!-- [ Design-sprint section ] start -->

                            <div class="col-xl-4 col-md-12">
                                <div class="card Design-sprint theme-bg1 box-shadow-unset border">
                                    <div class="card-header borderless pb-0">
                                        <h5 class="d-block mb-2"><?php echo e($slider->name); ?></h5>
                                        <?php if($slider->status == 'Active'): ?>
                                            <span
                                                class="d-inline-block badge badge-info mt-4"><?php echo e(__($slider->status)); ?></span>
                                        <?php else: ?>
                                            <span
                                                class="d-inline-block badge badge-danger mt-4"><?php echo e(__($slider->status)); ?></span>
                                        <?php endif; ?>
                                        <div class="card-header-right">
                                            <?php if(in_array('Modules\CMS\Http\Controllers\SliderController@update', $prms)): ?>
                                                <span class="header-btn slider-icon mr-2 cursor_pointer"
                                                    id="<?php echo e($slider->id); ?>" name="<?php echo e($slider->name); ?>"
                                                    status="<?php echo e($slider->status); ?>" data-bs-toggle="modal"
                                                    data-placement="top" data-bs-target="#edit-slider"
                                                    title="<?php echo e(__('Edit slider')); ?>">
                                                    <i class="feather icon-edit neg-transition-scale-svg "></i>
                                                </span>
                                            <?php endif; ?>
                                            <?php if(in_array('Modules\CMS\Http\Controllers\SliderController@delete', $prms)): ?>
                                                <form method="post"
                                                    action="<?php echo e(route('slider.delete', ['id' => $slider->id])); ?>"
                                                    id="delete-slider-<?php echo e($slider->id); ?>" accept-charset="UTF-8"
                                                    class="display_inline">
                                                    <?php echo csrf_field(); ?>
                                                    <span
                                                        class="header-btn slider-icon delete-button hw-1-8rem cursor_pointer"
                                                        data-bs-toggle="modal" data-label="Delete" data-delete="slider"
                                                        data-bs-target="#confirmDelete" data-id="<?php echo e($slider->id); ?>"
                                                        title="<?php echo e(__('Delete slider')); ?>"
                                                        data-title="<?php echo e(__('Delete :x', ['x' => __('Slider')])); ?>"
                                                        data-message="<?php echo e(__('Are you sure to delete this?')); ?>">
                                                        <i class="feather icon-trash-2"></i>
                                                    </span>
                                                </form>
                                            <?php endif; ?>
                                        </div>

                                    </div>
                                    <div class="card-block">

                                        <ul class="design-image">
                                            <a href="<?php echo e(route('slide.create', ['slug' => $slider->slug])); ?>">
                                                <li><button class="btn "><i
                                                            class="fas fa-plus f-14 ltr:me-0 rtl:ms-0"></i></button>
                                                </li>
                                            </a>
                                            <?php $__empty_2 = true; $__currentLoopData = $slider->slides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                <?php if($loop->iteration <= 3): ?>
                                                    <a href="<?php echo e(route('slide.create', ['slug' => $slider->slug])); ?>">
                                                        <li><img width="40" height="40"
                                                                class="rounded-circle object-fit-cover neg-transition-scale"
                                                                src="<?php echo e($slide->fileUrl()); ?>" alt="chat-user"></li>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                <?php echo e(__('No slide added yet.')); ?>

                                            <?php endif; ?>
                                            <?php if(count($slider->slides) > 3): ?>
                                                <li>+<?php echo e(count($slider->slides) - 3); ?></li>
                                            <?php endif; ?>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <!-- [ Design-sprint section ] end -->
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <?php echo e(__('No slider available.')); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div id="add-category-name" class="modal fade display_none" aria-modal="true" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo e(__('Add :x', ['x' => __('Slider')])); ?></h4>
                    <a type="button" class="close h4" data-bs-dismiss="modal">×</a>
                </div>
                <form action="<?php echo e(route('slider.store')); ?>" method="post" id="addPaymentForm" class="form-horizontal">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <div class="form-group row">
                            <label class="col-sm-4 control-label f-14 require" for="store-term"><?php echo e(__('Name')); ?></label>
                            <div class="col-sm-7">
                                <input type="text" class="form-control f-14 inputFieldDesign" name="name"
                                    placeholder="<?php echo e(__('Name')); ?>" id="store-term" value="" required
                                    minlength="3"
                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-4 control-label f-14"><?php echo e(__('Status')); ?></label>
                            <div class="col-sm-7">
                                <input type="hidden" name="status" value="Inactive">
                                <div class="switch d-inline m-r-10">
                                    <input class="is_default" type="checkbox" name="status" value="Active" id="is_default"
                                        checked>
                                    <label for="is_default" class="cr"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer py-0">
                        <div class="form-group row">
                            <label for="btn_save" class="col-sm-3 control-label f-14"></label>
                            <div class="col-sm-12">
                                <button type="submit"
                                    class="btn custom-btn-submit ltr:float-right rtl:float-left"><?php echo e(__('Create')); ?></button>
                                <button type="button"
                                    class="py-13 custom-btn-cancel float-end ltr:me-2 rtl:ms-2 h4"
                                    data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <div id="edit-slider" class="modal fade display_none" aria-modal="true" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title"><?php echo e(__('Edit :x', ['x' => __('Slider')])); ?></h4>
                    <a type="button" class="close h4" data-bs-dismiss="modal">×</a>
                </div>
                <form action="<?php echo e(route('slider.update')); ?>" method="post" id="edit-slider-form"
                    class="form-horizontal">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <input type="hidden" class="edit-id" id="edit-id" name="id">

                        <div class="form-group row">
                            <label class="col-sm-4 control-label f-14 require"
                                for="store-term"><?php echo e(__('Name')); ?></label>
                            <div class="col-sm-7">
                                <input type="text" class="form-control f-14 inputFieldDesign" name="name"
                                    placeholder="<?php echo e(__('Name')); ?>" id="name" value="" required
                                    minlength="3"
                                    oninvalid="this.setCustomValidity('<?php echo e(__('This field is required.')); ?>')">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-4 control-label f-14"><?php echo e(__('Status')); ?></label>
                            <div class="col-sm-7">
                                <input type="hidden" name="status" value="Inactive">
                                <div class="switch d-inline m-r-10">
                                    <input class="is_default" type="checkbox" name="status" id="edit_status">
                                    <label for="is_default" class="cr"></label>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer py-0">
                        <div class="form-group row">
                            <label for="btn_save" class="col-sm-3 control-label f-14"></label>
                            <div class="col-sm-12">
                                <button type="submit"
                                    class="btn custom-btn-submit float-end"><?php echo e(__('Update')); ?></button>
                                <button type="button"
                                    class="py-13 custom-btn-cancel float-end h4 ltr:me-2 rtl:ms-2"
                                    data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    
    <?php echo $__env->make('admin.layouts.includes.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/validation.min.js')); ?>"></script>
    <script src="<?php echo e(asset('Modules/CMS/Resources/assets/js/slider.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/CMS/Resources/views/slider/index.blade.php ENDPATH**/ ?>