
<?php $__env->startSection('page_title', __('Permission Roles')); ?>
<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('public/dist/css/role-permission.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Main content -->
    <div class="col-sm-12 list-container" id="permission-list-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10  ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    <?php echo $__env->make('admin.layouts.includes.account_settings_menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5> <?php echo e(__('Permission Roles')); ?> </h5>

                            <div class="card-header-right d-inline-block ltr:ps-3 rtl:pe-3">
                                <?php if(in_array('App\Http\Controllers\RoleController@create', $prms)): ?>
                                    <a href="<?php echo e(route('roles.create')); ?>" class="btn btn-outline-primary custom-btn-small">
                                        <span class="fa fa-plus"> &nbsp;</span><?php echo e(__('Add Role')); ?>

                                    </a>
                                <?php endif; ?>

                                <?php if(in_array('App\Http\Controllers\PermissionRoleController@generatePermission', $prms)): ?>
                                    <a href="<?php echo e(route('generatePermission.index')); ?>"
                                        class="btn btn-primary custom-btn-small">
                                        <span class="fas fa-cogs"> &nbsp;</span><?php echo e(__('Generate Permissions')); ?>

                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="card-body p-0 role-table">
                            <div class="card-block pt-2 px-2">
                                <div class="col-sm-12">
                                    <div class="table-responsive pt-2 panel panel-default border">
                                        <span class="d-block text-warning p-2 font-bold"><i
                                                class="fas fa-exclamation-triangle ltr:me-2 rtl:ms-2"></i><?php echo e(__('Permissions applied here are applicable to access that particular link. Please change it with extreme care.')); ?></span>
                                        <table class="table text-center myTable role-permission-table">
                                            <thead class="thead-sticky table-header">
                                                <tr>
                                                    <th width="27%"><?php echo e(__('Permissions')); ?></th>
                                                    <?php
                                                        $columnWidth = intval(80 / count($roles)) . '%';
                                                    ?>

                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <th width="<?php echo e($columnWidth); ?>"><?php echo e($role['name']); ?></th>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tr>
                                            </thead>

                                            <tbody>
                                                <?php $__currentLoopData = $permissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $webApiKey => $webApiValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $__currentLoopData = $webApiValue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $groupKey => $groupValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if(!empty($groupValue)): ?>
                                                            <?php
                                                                $data[$groupKey][$webApiKey] = $groupValue;
                                                            ?>
                                                        <?php endif; ?>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php
                                                    ksort($data);
                                                ?>
                                                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type => $allValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr data-bs-toggle="collapse"
                                                        data-value="<?php echo e($type . $loop->iteration); ?>"
                                                        class="accordion-toggle main-group">
                                                        <td class="text-left">
                                                            <a href="#!" class="collapsed text-dark text-bold"
                                                                data-bs-toggle="collapse" data-bs-target="#collapseTwo"
                                                                aria-expanded="false" aria-controls="collapseTwo"><i
                                                                    class="fas fa-plus ltr:ps-3 rtl:pe-3 arrow-icon"></i>
                                                                <?php echo e(ucwords(str_replace('_api', ' ', $type))); ?></a>
                                                            <span
                                                                class="badge badge-<?php echo e(strpos($type, 'api') != false ? 'secondary' : 'info'); ?>"><?php echo e(strpos($type, 'api') != false ? 'api' : 'web'); ?></span>
                                                        </td>
                                                        <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <?php if($loop->iteration == $loop->count - 1): ?>
                                                                <td colspan="2" class="position-relative">
                                                                    <input type="text"
                                                                        class="w-100 p-2 my-2 form-control position-absolute search-table"
                                                                        placeholder="<?php echo e(__('Search for permissions')); ?>...">
                                                                </td>
                                                            <?php elseif($loop->iteration < $loop->count - 1): ?>
                                                                <td></td>
                                                            <?php endif; ?>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tr>
                                                    <?php $__currentLoopData = $allValue; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <tr data-bs-toggle="collapse" data-bs-target="#<?php echo e($type . $key); ?>"
                                                            class="accordion-toggle sub-group hidden"
                                                            data-value="<?php echo e($type . $loop->parent->iteration); ?>">
                                                            <td class="text-left search">
                                                                <a href="#!" class="collapsed ml-3"
                                                                    data-bs-toggle="collapse show"
                                                                    data-bs-target="#collapseTwo" aria-expanded="false"
                                                                    aria-controls="collapseTwo"><i
                                                                        class="fas fa-plus ltr:ps-3 rtl:pe-3 arrow-icon"></i>
                                                                    <?php echo e(ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $key))); ?></a>
                                                            </td>
                                                            <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <td></td>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="12" class="hiddenRow border-none">
                                                                <div class="accordian-body collapse"
                                                                    id="<?php echo e($type . $key); ?>">
                                                                    <table class="table table-striped text-center">
                                                                        <tbody>
                                                                            <?php $__currentLoopData = $value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $methodKey => $methodValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <tr data-bs-toggle="collapse"
                                                                                    class="accordion-toggle"
                                                                                    data-bs-target="#demo10">
                                                                                    <td width="27%" class="text-left">
                                                                                        <span
                                                                                            class="d-block ml-48"><?php echo e(ucfirst(preg_replace('/(?<!\ )[A-Z]/', ' $0', $methodValue['name']))); ?></span>
                                                                                    </td>

                                                                                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                        <td class="text-center"
                                                                                            width="<?php echo e($columnWidth); ?>">

                                                                                            <?php if($role['slug'] == 'super-admin'): ?>
                                                                                                <span><i
                                                                                                        class="fas fa-check p-icon neg-transition-scale"></i></span>
                                                                                            <?php else: ?>
                                                                                                <span class="prms"
                                                                                                    data-permission_id="<?php echo e($methodValue['id']); ?>"
                                                                                                    data-role_id="<?php echo e($role['id']); ?>">
                                                                                                    <i class="fas <?php echo e(in_array($role['id'], $methodValue['role_ids']) ? 'fa-check text-success' : 'fa-times text-danger'); ?> p-icon p-prms"
                                                                                                        id="p_icon_<?php echo e($role['id']); ?>_<?php echo e($methodValue['id']); ?>"></i>
                                                                                                </span>
                                                                                            <?php endif; ?>
                                                                                        </td>
                                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                                </tr>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php echo $__env->make('admin.layouts.includes.delete-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('public/dist/js/custom/roles.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/resources/views/admin/permissionrole/index.blade.php ENDPATH**/ ?>