
<div class="tab-pane fade parent tax-setting-parent" id="v-pills-general" role="tabpanel" aria-labelledby="v-pills-general-tab">
    
    <?php echo $__env->make('tax::layout.tax-setting', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<div class="tab-pane fade parent tax-rate-data mt-25" id="v-pills-standard" role="tabpanel" aria-labelledby="v-pills-standard-tab">
    <?php echo $__env->make('tax::layout.standard-rate', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>

<?php $__currentLoopData = $tax_classes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <div class="tab-pane fade parent mt-25 tax-rate-data" id="v-pills-<?php echo e($tax->slug); ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo e($tax->slug); ?>-tab">
        <div class="noti-alert pad no-print warningMessage mt-2 px-2">
            <div class="alert warning-message abc">
                <strong id="warning-msg" class="msg"></strong>
            </div>
        </div>
        <div class="row ltr:ps-4 rtl:pe-4">
            <div class="col-sm-12 p-0">
                <div class="table-responsive">
                    <table class="table table-bordered table-hover">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(__('Name')); ?></th>
                                <th scope="col"><?php echo e(__('Country')); ?></th>
                                <th scope="col"><?php echo e(__('State')); ?></th>
                                <th scope="col"><?php echo e(__('City')); ?></th>
                                <th scope="col"><?php echo e(__('Post code')); ?></th>
                                <th width="100" scope="col"><?php echo e(__('Rate')); ?> %</th>
                                <th width="100" scope="col"><?php echo e(__('Priority')); ?></th>
                                <th width="5" scope="col"><?php echo e(__('Compound')); ?></th>
                                <th width="5" scope="col"><?php echo e(__('Shipping')); ?></th>
                                <th width="5" scope="col"><?php echo e(__('Action')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $tax->taxRates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td>
                                        <input type="hidden" name="id">
                                        <input type="hidden" name="tax_class_id" value="<?php echo e($tax->id); ?>">
                                        <input type="text" class="form-control" name="name" value="<?php echo e($rate->name); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control geolocale-country" list="country-list" maxlength="30" name="country" value="<?php echo e(empty($rate->country) ? '*' : $rate->country); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control geolocale-state" list="state-list" maxlength="30" name="state" value="<?php echo e(empty($rate->state) ? '*' : $rate->state); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" maxlength="30" name="city" value="<?php echo e(empty($rate->city) ? '*' : $rate->city); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control" maxlength="10" name="postcode" value="<?php echo e(empty($rate->postcode) ? '*' : $rate->postcode); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control positive-float-number" maxlength="16" name="tax_rate" value="<?php echo e(formatCurrencyAmount($rate->tax_rate)); ?>">
                                    </td>
                                    <td>
                                        <input type="text" class="form-control positive-int-number" maxlength="11" name="priority" value="<?php echo e($rate->priority); ?>">
                                    </td>
                                    <?php
                                        $randCompound = mt_rand();
                                        $randShipping = mt_rand();
                                    ?>
                                    <th>
                                        <div>
                                            <div class="switch switch-bg m-r-10">
                                                <input type="checkbox" name="compound" class="checkActivity" id="switch-<?php echo e($randCompound); ?>" value="<?php echo e($rate->compound); ?>" <?php echo e($rate->compound == 1 ? 'checked' : ''); ?>>
                                                <label for="switch-<?php echo e($randCompound); ?>" class="cr"></label>
                                            </div>
                                        </div>
                                    </th>
                                    <th>
                                        <div>
                                            <div class="switch switch-bg m-r-10">
                                                <input type="checkbox" name="shipping" class="checkActivity" id="switch-<?php echo e($randShipping); ?>" value="<?php echo e($rate->shipping); ?>" <?php echo e($rate->shipping == 1 ? 'checked' : ''); ?>>
                                                <label for="switch-<?php echo e($randShipping); ?>" class="cr"></label>
                                            </div>
                                        </div>
                                    </th>
                                    <td>
                                        <span class="text-dark cursor_pointer delete-button action-btn d-flex justify-content-center" title="<?php echo e(__('Delete Tax Rate')); ?>">
                                            <i class="fa fa-trash"></i>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td class="text-center" colspan="10"><?php echo e(__('No tax rate found.')); ?></td>
                                </tr>
                            <?php endif; ?>

                            <tr>
                                <td colspan="10" class="pt-3">
                                    <button type="button" data-id="<?php echo e($tax->id); ?>" class="btn custom-btn-submit btn-sm add-btn"><?php echo e(__('Add New')); ?></button>
                                    <?php if($tax->taxRates->count()): ?>
                                        <button type="submit" data-id="<?php echo e($tax->id); ?>" class="btn custom-btn-submit btn-sm update-btn"><?php echo e(__('Save')); ?></button>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



<div class="tab-pane fade parent tax-setting-parent mt-25" id="v-pills-help" role="tabpanel" aria-labelledby="v-pills-help-tab">
    <?php echo $__env->make('tax::layout.help', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>


<datalist id="country-list"></datalist>
<datalist id="state-list"></datalist>
<?php /**PATH /home/creativedesignbd/ecommerce9.creativedesign.com.bd/Modules/Tax/Resources/views/layout/contents.blade.php ENDPATH**/ ?>